<?php
session_start();
require 'connect.php';

if (!isset($_SESSION['user_id']) || !isset($_POST['message']) || !isset($_POST['roomid'])) {
  echo json_encode(['status' => 'error', 'message' => 'Invalid request']);
  exit;
}

$sender_id = $_SESSION['user_id'];
$message = trim($_POST['message']);
$room_id = $_POST['roomid'];
$time = date('Y-m-d H:i:s');

// Get members
$stmt = $conn->prepare("SELECT user_id FROM room_members WHERE room_id = ?");
$stmt->execute([$room_id]);
$members = $stmt->fetchAll(PDO::FETCH_COLUMN);

// Store for each member
$insert = $conn->prepare("INSERT INTO messages (message_id, message_text, sent_by_id, sent_to_id, date_time_sent, status, room_id)
  VALUES (?, ?, ?, ?, ?, 'sent', ?)");

$mid = uniqid();

foreach ($members as $uid) {
  $insert->execute([$mid, $message, $sender_id, $uid, $time, $room_id]);
}

// Also store for sender
//$insert->execute([$mid, $message, $sender_id, $sender_id, $time, $room_id]);

echo json_encode(['status' => 'success']);
?>