<?php
session_start();
require 'connect.php';

$user_id = $_SESSION['user_id'];
$room_id = $_GET['roomid'];
$last_id = intval($_GET['last_id'] ?? 0);
$initial = $_GET['initial'] ?? 0;

if ($initial) {
  $stmt = $conn->prepare("SELECT * FROM messages WHERE sent_to_id = ? AND room_id = ? ORDER BY id DESC LIMIT 10");
} else {
  $stmt = $conn->prepare("SELECT * FROM messages WHERE sent_to_id = ? AND room_id = ? AND id > ? ORDER BY id ASC");
}
$stmt->execute($initial ? [$user_id, $room_id] : [$user_id, $room_id, $last_id]);
$messages = $stmt->fetchAll(PDO::FETCH_ASSOC);

$result = [];
foreach ($messages as $msg) {
  $senderStmt = $conn->prepare("SELECT user_name FROM users WHERE id = ?");
  $senderStmt->execute([$msg['sent_by_id']]);
  $sender = $senderStmt->fetchColumn();

  $result[] = [
    'id' => $msg['id'],
    'sender' => $sender ?: 'Unknown',
    'text' => $msg['message_text']
  ];
}

echo json_encode(['messages' => array_reverse($result)]);
?>