<?php
session_start();
require_once 'connect.php';

if (!isset($_SESSION['user_id'])) {
    echo 'unauthorized';
    exit;
}

if (isset($_POST['roomName'])) {
    $roomName = trim($_POST['roomName']);
    $description = trim($_POST['description']);
    $userId = $_SESSION['user_id'];

    try {
        // Start transaction
        $conn->beginTransaction();

        // Insert into chat_rooms
        $sql = "INSERT INTO chat_rooms (room_name, description, created_by, created_at)
                VALUES (:roomName, :description, :userId, NOW())";
        $stmt = $conn->prepare($sql);
        $stmt->execute([
            ':roomName'    => $roomName,
            ':description' => $description,
            ':userId'      => $userId
        ]);

        // Get the inserted room ID
        $roomId = $conn->lastInsertId();

        // Insert into room_members
        $sql2 = "INSERT INTO room_members (room_id, user_id, member_type)
                 VALUES (:roomId, :userId, 'Admin')";
        $stmt2 = $conn->prepare($sql2);
        $stmt2->execute([
            ':roomId' => $roomId,
            ':userId' => $userId
        ]);

        $_SESSION['current_room_id'] = $roomId;

        // Commit transaction
        $conn->commit();
        echo 'success';

    } catch (PDOException $e) {
        $conn->rollBack();
        echo 'Database error: ' . $e->getMessage();
    }

} else {
    echo 'Missing data.';
}
